rm(list = ls())
source("_funciones.txt")

##################################################################################

datos = read.table("Wissel.txt", header = T, sep=";")
head(datos)
datos = datos[,-5] # quito CP
datos = datos[,-1] # quito t
head(datos)
y = datos[,1]
x = as.matrix(datos[,-1])

##

reg = lm(y~x)
summary(reg)

##

FIV(x)

NC(x)
X = cbind(array(1,length(y)),x)
NC(X)
((NC(X)-NC(x))/NC(X))*100

##################################################################################

n = length(y)
k = dim(X)[2]
hi = array(-1,k)
for (i in 1:k){
  hi[i] = (1/n)*(((1.96/summary(reg)[[4]][i,3])^2)*(n-k)+k)
}
hi
h = ceiling(max(hi[-1])) # quito la cte
h

##

data = datos
for (i in 1:h){
  datos = rbind(datos,data)
}
write(t(datos), "Wissel-aumentado.txt", ncolumns=dim(datos)[2], sep=";")

##################################################################################

yA = datos[,1]
xA = as.matrix(datos[,-1])

##

regA = lm(yA~xA)
summary(regA)

##

FIV(xA)

NC(xA)
XA = cbind(array(1,length(yA)),xA)
NC(XA)
((NC(XA)-NC(xA))/NC(XA))*100

##

res1 = cbind(summary(reg)[[4]][,1],summary(reg)[[4]][,4],summary(regA)[[4]][,1],summary(regA)[[4]][,4])
colnames(res1) = c("Estimacin", "p-valor", "Estimacin A", "p-valor A")
res1

res2 = rbind(c(FIV(x)[-1], NC(x), NC(X)), c(FIV(xA)[-1], NC(xA), NC(XA)))
rownames(res2) = c("Original", "Aumentado")
colnames(res2) = c("FIV", "NC sin CTE", "NC")
res2

##################################################################################

tol = 0.01
media = 10
dv = 10

xA.p = matrix(-1, dim(xA)[1], dim(xA)[2])
medias = matrix(-1, 1, dim(xA)[2])
for (i in 1:dim(xA)[2]){
  xA.p[,i] = perturb(xA[,i], media, dv, tol)
  medias[i] = mean(abs(xA[,i]-xA.p[,i]))
}
medias

datos.p = cbind(yA,xA.p)
write(t(datos.p), "Wissel-aumentado.perturbado.txt", ncolumns=dim(datos.p)[2], sep=";")

regA.p = lm(yA~xA.p)
summary(regA.p)

##

res3 = cbind(summary(reg)[[4]][,1],summary(regA)[[4]][,1],summary(regA.p)[[4]][,1])
colnames(res3) = c("Estimacin", "Estimacin A", "Estimacion A perturb")
res3

##

betaA = as.double(regA$coefficients)
betaA.p = as.double(regA.p$coefficients)
(norm(betaA-betaA.p,"2")/norm(betaA,"2"))*100

tols = matrix(-1, 1, dim(xA)[2])
for (i in 1:dim(xA)[2]){
  tols[i] = (norm(xA[,i]-xA.p[,i],"2")/norm(xA[,i],"2"))*100
}
tols

##################################################################################

datos.perturb = read.table("Wissel-aumentado.perturbado.txt", header = F, sep=";")
head(datos.perturb)
y = datos.perturb[,1]
x = as.matrix(datos.perturb[,-1])

##

regA.p = lm(y~x)
summary(regA.p)

betaA = as.double(regA$coefficients)
betaA.p = as.double(regA.p$coefficients)
(norm(betaA-betaA.p,"2")/norm(betaA,"2"))*100

##

FIV(x)

NC(x)
X = cbind(array(1,length(y)),x)
NC(X)
((NC(X)-NC(x))/NC(X))*100

